/**
 *
 * \file        cresnet_host.h
 *
 * \brief       header file for
 *              low level uart hardware class as a foundation for CresnetTask class
 *
 * \author      Gennady
 *
 * \date        8/24/2008
 *
 */
#ifndef _CRESNET_HOST_H_
#define _CRESNET_HOST_H_

#include "Cresnet.h"
#include "errors.h"
#include <string.h>
#include "os.h"
#include "uart_cresnet_master.h"
#include "console.h"
//#include <ctype.h>
#include "cip.h"
#include "memorymanager.h"
#include <stdlib.h>
#include <stdio.h>

#include "Cresnethardware.hpp"
#include "OsEvent.hpp"
#include "dm_cresnet_host.hpp"

#define TOTAL_NUMBER_OF_DM_MASTERS 2
#define DM_HOST_POLL_WAIT_MS 10 // ticks to wait

#define MISSING_DEVICE_POLLS 2  //  missed polls before declaring device OFFLINE (Should never change from 2!!)
#define REPORT_IF_MISSING_SET_MASK_BIT_IF_PRESENT   100
#define REPORT_IF_MISSING_OR_IF_PRESENT             101

#define CRESNET_MASTER_RX_QUEUE_ITEMS 2
#define HOST_SEMAPHORE_TOUT  1000 // in ticks

                                 //
#define ONE_CRESNET_CHAR_TIME (287)  // in micro seconds 286.440 uS
#define ONE_AND_HALF_CHAR_TIME ((ONE_CRESNET_CHAR_TIME*15)/10)  // 390.625 uS
#define TWO_CRESNET_CHAR_TIME (ONE_CRESNET_CHAR_TIME*2)  // 520.834 uS
#define TWO_AND_HALF_CHAR_TIME (ONE_CRESNET_CHAR_TIME+ONE_AND_HALF_CHAR_TIME)  // 520.834 uS
#define THREE_CRESNET_CHAR_TIME (ONE_CRESNET_CHAR_TIME*3)  //
#define FOUR_CRESNET_CHAR_TIME (ONE_CRESNET_CHAR_TIME*4)  //
#define TEN_CRESNET_CHAR_TIME (ONE_CRESNET_CHAR_TIME*12)  // 2.60417 mS
#define TWELVE_CRESNET_CHAR_TIME (ONE_CRESNET_CHAR_TIME*12)  // 2.60417 mS
#define TWENTY_CRESNET_CHAR_TIME (ONE_CRESNET_CHAR_TIME*22)  // 2.60417 mS
#define DM_WAIT_FOR_RESPONSE_MS ((ONE_CRESNET_CHAR_TIME*256)/1000+10) // for DmPoll()
#define DM_WAIT_FOR_SYNC_END_MS 5 // for SendSync()

// m_iDebug member bits
#define DMH_DEB_NONE                 0x0000
#define DMH_DEB_TX_BIT               0x0001
#define DMH_DEB_RX_BIT               0x0002
#define DMH_DEB_RX_TASK_BIT          0x0004
#define DMH_DEB_EVENTS_BIT           0x0008
#define DMH_DEB_ERRORS_BIT           0x0010
#define DMH_DEB_PROCES_PACKET_RX_BIT 0x0020
#define DMH_DEB_PROCES_PACKET_TX_BIT 0x0040
#define DMH_DEB_SLAVE_ENQUE_PACKET_BIT     0x0080

#define USE_DM_NET_DEBUG
// #undef USE_DM_NET_DEBUG

#endif // _CRESNET_HOST_H_

